package demo.common;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JComboBox;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

import demo.module.LoginModule;
import netsdk.lib.CommonFunctions;
import netsdk.lib.DeviceSdk;
import netsdk.lib.ErrorCodeAndConst;
import netsdk.struct.NET_SDK_DEV_SUPPORT;
import unitTest.NET_SDK_A2IPC_Test.devIntelist;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.JTextArea;

public class ThermalConfig extends JPanel {
	private JComboBox comboBox;
	private JButton btnGet;
	private JCheckBox chckbxNewCheckBox;
	private JButton btnSet;
	private JTextArea textArea;
	private JScrollPane js;
	/**
	 * Create the panel.
	 */
	public ThermalConfig() {
		setLayout(null);
		
		comboBox = new JComboBox();
		comboBox.setBounds(26, 54, 43, 20);
		add(comboBox);
		
		btnGet = new JButton("Get");
		btnGet.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				int pos = ErrorCodeAndConst.supportThermometry; 
				
				NET_SDK_DEV_SUPPORT.ByReference nsds = new NET_SDK_DEV_SUPPORT.ByReference();
				boolean ret = DeviceSdk.INSTANCE.NET_SDK_GetDeviceSupportFunction(LoginModule.m_hLoginHandle, nsds);
				if(ret) {
												
				}
				
				
				if((nsds.support & (1 << pos)) >> pos == 1) {
					 String m_sendUrl = "GetTakeTemperatureConfig";
					 String m_sendXml = "";
					 IntByReference lpBytesReturned = new IntByReference();  
					 Pointer pNativeData = new Memory(nsds.size());
					 CommonFunctions.SetStructDataToPointer(nsds, pNativeData, 0);
			         ret = DeviceSdk.INSTANCE.NET_SDK_TransparentConfig(LoginModule.m_hLoginHandle, m_sendXml, m_sendUrl, pNativeData, nsds.size(), lpBytesReturned);
			         if(ret) {
			        	 int vesionLen = lpBytesReturned.getValue();       	
			         	 byte[] byteArray = pNativeData.getByteArray(0, vesionLen);
			         	 String resXml = new String(byteArray);
			         	textArea.setText(resXml);
			         }
			      // 释放内存
						long peer = Pointer.nativeValue(pNativeData);
						Native.free(peer);// 手动释放内存
						Pointer.nativeValue(pNativeData, 0);					 
				}										
			}
		});
		btnGet.setBounds(183, 24, 89, 23);
		add(btnGet);
		
		chckbxNewCheckBox = new JCheckBox(Res.string().getEnable());
		chckbxNewCheckBox.setBounds(26, 24, 56, 23);
		add(chckbxNewCheckBox);
		
		btnSet = new JButton("Set");
		btnSet.setBounds(282, 24, 89, 23);
		add(btnSet);
		
		textArea = new JTextArea();
		//textArea.setBounds(26, 85, 345, 185);
		
		
		js = new JScrollPane(textArea);
		js.setBounds(26, 85, 345, 123);

		//分别设置水平和垂直滚动条自动出现 

		js.setHorizontalScrollBarPolicy( 

		JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED); 

		js.setVerticalScrollBarPolicy( 

		JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED); 
		add(js);

	}
}
